//
//  Priority.swift
//  Do It
//
//  Created by Jim Dovey on 2/14/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

enum Priority: String, Codable, CaseIterable {
    case low
    case normal
    case high
    case urgent

    var localizedName: LocalizedStringKey {
        LocalizedStringKey(rawValue.capitalized)
    }
}

extension Priority: Comparable {
    static func < (lhs: Priority, rhs: Priority) -> Bool {
        return allCases.firstIndex(of: lhs)! < allCases.firstIndex(of: rhs)!
    }
}
